function [ys,check] = QuantMig_D92_DSGE_AutoMig_v12_19_Oct_21_steadystate(ys,junk,do_steady_print)
global M_ 

% read out parameters to access them with their name
NumberOfParameters = M_.param_nbr;
for ii = 1:NumberOfParameters
  paramname = deblank(M_.param_names(ii,:));
  eval([ paramname ' = M_.params(' int2str(ii) ');']);
end
% initialize indicator

options=optimset(); % set options for numerical solver
check = 0 ;
bettap =1/1.02;
r_ss = 1/bettap -1 ;
deltta = 0.025 ;
delttaz = 0.025 ;
bm_ss = 0 ;
bh_ss = 0 ;
b_ss = bh_ss + bm_ss ;


%tauc_ss = 0.183 ; %0.143 %0.183
tauf_ss = 0.1 ;%0.235 ;
tauw_ss = 0.1 ;




kappac	=	0 	;
kappah	=	0	;
sigmap	=	1.500	;
sigmalp	=	1.500	;
etap	=	2.000	;
etalp	=	2.00	;
zeta       =   4.0000 ; 


rhoa	=	0.7314	;
rhom	=	0.9149	;
rhoyf	=	0.7153	;
rhopsi	=	0.4392	;
rhopsih	=	0.5907	;
rhopsix	=	0.6524	;
rhopsixz	=	rhopsix	;
rhogc	=	0.7424	;
rhozm	=	0.5662	;
rhobp = 0.5 ;			
			
			
ac	=	3.4650	;
ces	=	4.0077	;
bhc	=	0.011	;
gammap	=	0.3127	;
rhoz	=	0.5650	;
zetabz	=	0.010 ;%0.1845	;
zetayz	=	0.010 ;%0.2265	;
rhogcv	=	0.5574	;
zetabgc	=	0.010 ;%0.1714	;
zetaygc	=	0.010 ;%0.1878	;


%%%%MONTHLY
rhoa	=	0.7949	;
rhogc	=	0.6769	;
rhogcv	=	0.8764	;
rhoyf	=	0.6418	;
rhom	=	0.3653	;
rhopsi	=	0.4113	;
rhopsix	=	0.4519	;
rhoz	=	0.5357	;
rhozm	=	0.5470	;
zetayz	=	0.03154	;
zetabz	=	0.06107	;
zetaygc	=	0.02694	;
zetabgc	=	0.0048	;
thetap	=	1.2941	;
phixp	=	6.1631	;
bhc	=	0.0089	;
			
					
phik = 1;
phiz = 1 ;
kappaxp = 1;
phixp = phik ;


rhovarphi = rhom ;

varphih_ss = 0.60;
varphim_ss =0.10 ;
varphimh_ss = 0.05 ;
varphil_ss = 1- varphih_ss - varphim_ss - varphim_ss;

ah = 0.8000 ;
amh = 0.7000 ;
am = 0.4500 ;
al = 0.5000 ;

rhonh = 0.0390 ;
rhonmh = 0.0490 ;
rhonm = 0.0855 ;
rhonl = 0.0600 ;

Gammahp = 0.50 ;
Gammamp = 0.50 ;
Gammalp = 0.50 ;
Gammamhp = 0.50 ;

kappavh = 0.15 ;
kappavm = 0.13 ;
kappavl = 0.13 ;
kappavmh = kappavh ; %0.15 ;

partich_ss = 0.8590;
particmh_ss =  0.8290;
particm_ss = 0.7390 ;
particl_ss = 0.7660;

unemph_ss =  0.039 ;%0.0503 ; 
unempmh_ss =  0.059 ;%0.0503 ; 
unempm_ss =  0.1025 ;%0.060 ;
unempl_ss =  0.0703 ; %0.029 ;

Uh_ss = varphih_ss*partich_ss*unemph_ss ;
Um_ss = varphim_ss*particm_ss*unempm_ss ;
Ul_ss = varphil_ss*particl_ss*unempl_ss ;
Umh_ss = varphimh_ss*particmh_ss*unempmh_ss ;

Nh_ss = (1/unemph_ss - 1)*Uh_ss ;
Nm_ss = (1/unempm_ss - 1)*Um_ss ;
Nl_ss = (1/unempl_ss - 1)*Ul_ss ;
Nmh_ss = (1/unempmh_ss - 1)*Umh_ss ;

mh_ss = rhonh*Nh_ss ;
mm_ss = rhonm*Nm_ss ;
ml_ss = rhonl*Nl_ss ;
mmh_ss = rhonmh*Nmh_ss ;

vh_ss = ((mh_ss)/(ah*(Uh_ss^(1-Gammahp))))^(1/Gammahp) ;
vm_ss = ((mm_ss)/(am*(Um_ss^(1-Gammamp))))^(1/Gammamp) ;
vl_ss = ((ml_ss)/(al*(Ul_ss^(1-Gammalp))))^(1/Gammalp) ;
vmh_ss = ((mmh_ss)/(amh*(Umh_ss^(1-Gammamhp))))^(1/Gammamhp) ;

oomegah_ss = mh_ss/Uh_ss ;
oomegam_ss = mm_ss/Um_ss ;
oomegal_ss = ml_ss/Ul_ss ;
oomegamh_ss = mmh_ss/Umh_ss ;

upsilonh_ss = mh_ss/vh_ss ;
upsilonm_ss = mm_ss/vm_ss ;
upsilonl_ss = ml_ss/vl_ss ;
upsilonmh_ss = mmh_ss/vmh_ss ;

thetah_ss = vh_ss/Uh_ss ;
thetam_ss = vm_ss/Um_ss ;
thetal_ss = vl_ss/Ul_ss ;
thetamh_ss = vmh_ss/Umh_ss ;

uh_ss = Uh_ss/varphih_ss ;
um_ss = Um_ss/varphim_ss ;
nh_ss = Nh_ss/varphih_ss ;
nm_ss = Nm_ss/varphim_ss ;
lh_ss = 1 - nh_ss - uh_ss ;
lm_ss = 1 - nm_ss - um_ss ;

ul_ss = Ul_ss/varphil_ss ;
nl_ss = Nl_ss/varphil_ss ;
ll_ss = 1 - nl_ss - ul_ss ;

umh_ss = Umh_ss/varphimh_ss ;
nmh_ss = Nmh_ss/varphimh_ss ;
lmh_ss = 1 - nmh_ss - umh_ss ;

 


n_ss = 1;

hh_ss = n_ss ;
hm_ss = n_ss ;
hl_ss = n_ss ;
hmh_ss = n_ss ;


alephl = Nl_ss/(Nm_ss+Nl_ss) ;
alephm = Nm_ss/(Nm_ss+Nl_ss) ;
alephh = Nh_ss/(Nmh_ss+Nh_ss) ;
eoslm = 1.1 ;
thelbp = eoslm ;

Thelbp = (thelbp-1)/thelbp ;

lbraggl_ss = ((alephl^(1/thelbp))*(Nl_ss*hl_ss)^Thelbp + (alephm)^(1/thelbp)*(Nm_ss*hm_ss)^Thelbp)^(1/Thelbp) ;
lbraggh_ss = ((alephh^(1/thelbp))*(Nh_ss*hh_ss)^Thelbp + (1-alephh)^(1/thelbp)*(Nmh_ss*hmh_ss)^Thelbp)^(1/Thelbp) ;

%lbraggl_ss = Nl_ss*hl_ss ;
%lbraggh_ss = Nh_ss*hh_ss ;

mpk_ss = 1/bettap - (1-deltta) ;
mpz_ss = 1/bettap - (1-delttaz) ;

% % These work!!!
% rhop =  1/1.1;
% zetap = 0.25 ;%0.45 ;
% ap = 0.450 ;
% epsp = 1/0.9; 
% bp= 1 ;
% ep = 0.450 ;
% sigp = 1/2 ;

% %/**/


% %Berg et al 2 This works
% sigp = 3 ;%EoS Ll vs Z% 
% rhop =  0.4; %EoS k vs Lh
% epsp = max(1,sigp/3); %%Eos X vs V
% zetap = 0.45 ; % share K vs Lh
% ap = 0.450 ; %Share V vs X
% bp= 0.5 ; %%Prod of Z
% ep = 0.450 ; %Share Ll vs Z


% sigp = 3.5 ;%EoS Ll vs Z% 
% rhop =  0.45; %EoS k vs Lh
% epsp = max(1,sigp/3); %%Eos X vs V
% zetap = 0.45 ; % share K vs Lh
% Ap = 0.40 ; %Share V vs X
% bp= 1/2 ; %%Prod of Z
% ep = 0.60 ; %Share Ll vs Z

%%29April2021
%Model 1
% sigp = 2.5 ; %Eos L vs  Z (sig 2 in Berg et al)
% epsp = 0.67 ; %Eos K,H vs L,Z (sig 1 in Berg et al)
% rhop = 0.33 ; %Eos K vs S (sig 3 in Berg et al)
% %Model 2
% sigp = 5 ; %Eos L vs  Z (sig 2 in Berg et al)
% epsp = 0.5 ; %Eos K,H vs L,Z (sig 1 in Berg et al)
% rhop = 0.5 ; %Eos K vs S (sig 3 in Berg et al)
% %Model 3
% sigp = 5 ; %Eos L vs  Z (sig 2 in Berg et al)
% epsp = 1 ; %Eos K,H vs L,Z (sig 1 in Berg et al)
% rhop = 0.5 ; %Eos K vs S (sig 3 in Berg et al)
%Model 1b taken from model 1 then altered so wl is actually respectable
sigp = 1.8 ; %Eos L vs  Z (sig 2 in Berg et al)
epsp = 0.87 ; %Eos K,H vs L,Z (sig 1 in Berg et al)
rhop = 0.55 ; %Eos K vs S (sig 3 in Berg et al)

Ap = 0.45 ;
zetap = 0.4 ;
ep = 0.8 ;
bp = 1;



a_ss = 1;


Sigp = (sigp-1)/sigp ;
Rhop = (rhop-1)/rhop ;
alphap = (epsp-1)/epsp ;
delkh = varphih_ss/(varphimh_ss+varphih_ss) ;
kappakp = 1.01 ; %%Eos Kh vs Km*/
KapKP = (kappakp-1)/kappakp ;

% F = @(x) [mpk_ss - (1-Ap)^(1/epsp)*zetap^(1/rhop)*a_ss*(Ap^(1/epsp)*((ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*x(2))^Sigp)^(alphap/Sigp)) + (1-Ap)^(1/epsp)*((zetap^(1/rhop)*x(1)^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop)))^(1/alphap-1)*(zetap^(1/rhop)*x(1)^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop-1)*x(1)^(Rhop-1) ;
% mpz_ss - Ap^(1/epsp)*(1-ep)^(1/sigp)*(bp)^Sigp*a_ss*(Ap^(1/epsp)*((ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*x(2))^Sigp)^(alphap/Sigp)) + (1-Ap)^(1/epsp)*((zetap^(1/rhop)*x(1)^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop)))^(1/alphap-1)*(ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*x(2))^Sigp)^(alphap/Sigp-1)*x(2)^(Sigp-1) ];
% InitialGuess = [1;1];
% Options = optimset('Display','off');
% XY = fsolve(F, InitialGuess, Options);
% k_ss = XY(1);
% Z_ss = XY(2);

F = @(x) [mpk_ss - (1-Ap)^(1/epsp)*(zetap)^(1/rhop)*a_ss*delkh*(Ap^(1/epsp)*((ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*x(3))^Sigp)^(alphap/Sigp)) + (1-Ap)^(1/epsp)*((zetap^(1/rhop)*((delkh*x(1)^(KapKP) + (1-delkh)*x(2)^(KapKP))^(1/KapKP))^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop)))^(1/alphap-1)*(zetap^(1/rhop)*((delkh*x(1)^(KapKP) + (1-delkh)*x(2)^(KapKP))^(1/KapKP))^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop-1)*(delkh*(x(1))^(KapKP)+(1-delkh)*(x(2))^(KapKP))^(Rhop/KapKP-1)*(x(1))^(KapKP-1)    ;
mpk_ss - (1-Ap)^(1/epsp)*(zetap)^(1/rhop)*a_ss*(1-delkh)*(Ap^(1/epsp)*((ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*x(3))^Sigp)^(alphap/Sigp)) + (1-Ap)^(1/epsp)*((zetap^(1/rhop)*((delkh*x(1)^(KapKP) + (1-delkh)*x(2)^(KapKP))^(1/KapKP))^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop)))^(1/alphap-1)*(zetap^(1/rhop)*((delkh*x(1)^(KapKP) + (1-delkh)*x(2)^(KapKP))^(1/KapKP))^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop-1)*(delkh*(x(1))^(KapKP)+(1-delkh)*(x(2))^(KapKP))^(Rhop/KapKP-1)*(x(2))^(KapKP-1)     ;
mpz_ss - Ap^(1/epsp)*(1-ep)^(1/sigp)*(bp)^Sigp*a_ss*(Ap^(1/epsp)*((ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*x(3))^Sigp)^(alphap/Sigp)) + (1-Ap)^(1/epsp)*((zetap^(1/rhop)*((delkh*x(1)^(KapKP) + (1-delkh)*x(2)^(KapKP))^(1/KapKP))^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop)))^(1/alphap-1)*(ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*x(3))^Sigp)^(alphap/Sigp-1)*x(3)^(Sigp-1) ];
InitialGuess = [1;1;1];
Options = optimset('Display','off');
XY = fsolve(F, InitialGuess, Options);
kh_ss = XY(1);
km_ss = XY(2);
Z_ss = XY(3);

k_ss = ((delkh*kh_ss^(KapKP) + (1-delkh)*km_ss^(KapKP))^(1/KapKP)) ;

V_ss = (ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*Z_ss)^Sigp)^(1/Sigp) ;
X_ss = (zetap^(1/rhop)*k_ss^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(1/Rhop) ;
y_ss = a_ss*(Ap^(1/epsp)*(V_ss^(alphap)) + (1-Ap)^(1/epsp)*(X_ss^alphap))^(1/alphap) ;


lbrh_ss = Nh_ss*hh_ss ;
lbrm_ss = Nm_ss*hm_ss ;
lbrl_ss = Nl_ss*hl_ss ;
lbrmh_ss = Nmh_ss*hmh_ss ;


%kh_ss = (k_ss^(KapKP))/((1-delkh)+(delkh))^(1/KapKP) ;
%km_ss = kh_ss ;
% kh_ss = k_ss/varphih_ss ;
% km_ss = k_ss/varphimh_ss ;
%km_ss = (k_ss^KapKP/( (delkh*((1-delkh)/delkh)^(KapKP/(KapKP-1)))+ (1-delkh)))^(1/KapKP) ;
%kh_ss = ((1-delkh)/delkh)^(1/(KapKP-1))*km_ss ;

xh_ss = deltta*kh_ss ;
xm_ss = deltta*km_ss ;
x_ss = deltta*k_ss ;


mpkk_ss = (1-Ap)^(1/epsp)*zetap^(1/rhop)*a_ss*(Ap^(1/epsp)*((ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*Z_ss)^Sigp)^(alphap/Sigp)) + (1-Ap)^(1/epsp)*((zetap^(1/rhop)*k_ss^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop)))^(1/alphap-1)*(zetap^(1/rhop)*k_ss^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop-1)*k_ss^(Rhop-1) ;
mpzz_ss = Ap^(1/epsp)*(1-ep)^(1/sigp)*(bp)^Sigp*a_ss*(Ap^(1/epsp)*((ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*Z_ss)^Sigp)^(alphap/Sigp)) + (1-Ap)^(1/epsp)*((zetap^(1/rhop)*k_ss^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop)))^(1/alphap-1)*(ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*Z_ss)^Sigp)^(alphap/Sigp-1)*Z_ss^(Sigp-1) ;


mplm_ss = Ap^(1/epsp)*(ep)^(1/sigp)*(alephm)^(1/thelbp)*(Ap^(1/epsp)*((ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*Z_ss)^Sigp)^(alphap/Sigp)) + (1-Ap)^(1/epsp)*((zetap^(1/rhop)*k_ss^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop)))^(1/alphap-1)*(ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*Z_ss)^Sigp)^(alphap/Sigp-1)*((alephl^(1/thelbp))*(Nl_ss*hl_ss)^Thelbp + (alephm)^(1/thelbp)*(Nm_ss*hm_ss)^Thelbp)^(Sigp/Thelbp-1)*(Nm_ss*hm_ss)^(Thelbp-1)  ;
mpll_ss = Ap^(1/epsp)*(ep)^(1/sigp)*(alephl)^(1/thelbp)*(Ap^(1/epsp)*((ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*Z_ss)^Sigp)^(alphap/Sigp)) + (1-Ap)^(1/epsp)*((zetap^(1/rhop)*k_ss^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop)))^(1/alphap-1)*(ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*Z_ss)^Sigp)^(alphap/Sigp-1)*((alephl^(1/thelbp))*(Nl_ss*hl_ss)^Thelbp + (alephm)^(1/thelbp)*(Nm_ss*hm_ss)^Thelbp)^(Sigp/Thelbp-1)*(Nl_ss*hl_ss)^(Thelbp-1)  ;

%mpll_ss = Ap^(1/epsp)*(ep)^(1/sigp)*(Ap^(1/epsp)*((ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*Z_ss)^Sigp)^(alphap/Sigp)) + (1-Ap)^(1/epsp)*((zetap^(1/rhop)*k_ss^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop)))^(1/alphap-1)*(ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*Z_ss)^Sigp)^(alphap/Sigp-1)*((Nl_ss*hl_ss))^(Sigp-1) ;

mplh_ss = (1-Ap)^(1/epsp)*(1-zetap)^(1/rhop)*alephh^(1/thelbp)*a_ss*(Ap^(1/epsp)*((ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*Z_ss)^Sigp)^(alphap/Sigp)) + (1-Ap)^(1/epsp)*((zetap^(1/rhop)*k_ss^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop)))^(1/alphap-1)*(zetap^(1/rhop)*k_ss^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop-1)*((alephh^(1/thelbp))*(Nh_ss*hh_ss)^Thelbp + (1-alephh)^(1/thelbp)*(Nmh_ss*hmh_ss)^Thelbp)^(Rhop/Thelbp-1)*(Nh_ss*hh_ss)^(Thelbp-1) ;
mplmh_ss = (1-Ap)^(1/epsp)*(1-zetap)^(1/rhop)*(1-alephh)^(1/thelbp)*a_ss*(Ap^(1/epsp)*((ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*Z_ss)^Sigp)^(alphap/Sigp)) + (1-Ap)^(1/epsp)*((zetap^(1/rhop)*k_ss^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop)))^(1/alphap-1)*(zetap^(1/rhop)*k_ss^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop-1)*((alephh^(1/thelbp))*(Nh_ss*hh_ss)^Thelbp + (1-alephh)^(1/thelbp)*(Nmh_ss*hmh_ss)^Thelbp)^(Rhop/Thelbp-1)*(Nmh_ss*hmh_ss)^(Thelbp-1) ;

%mplh_ss = (1-Ap)^(1/epsp)*(1-zetap)^(1/rhop)*a_ss*(Ap^(1/epsp)*((ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*Z_ss)^Sigp)^(alphap/Sigp)) + (1-Ap)^(1/epsp)*((zetap^(1/rhop)*k_ss^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop)))^(1/alphap-1)*(zetap^(1/rhop)*k_ss^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop-1)*(Nh_ss*hh_ss)^(Rhop-1) ;



mpkh_ss = (1-Ap)^(1/epsp)*(zetap)^(1/rhop)*a_ss*delkh*(Ap^(1/epsp)*((ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*Z_ss)^Sigp)^(alphap/Sigp)) + (1-Ap)^(1/epsp)*((zetap^(1/rhop)*k_ss^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop)))^(1/alphap-1)*(zetap^(1/rhop)*k_ss^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop-1)*(delkh*(kh_ss)^(KapKP)+(1-delkh)*(km_ss)^(KapKP))^(Rhop/KapKP-1)*(kh_ss)^(KapKP-1)    ;
mpkm_ss = (1-Ap)^(1/epsp)*(zetap)^(1/rhop)*a_ss*(1-delkh)*(Ap^(1/epsp)*((ep^(1/sigp)*lbraggl_ss^(Sigp) + (1-ep)^(1/sigp)*(bp*Z_ss)^Sigp)^(alphap/Sigp)) + (1-Ap)^(1/epsp)*((zetap^(1/rhop)*k_ss^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop)))^(1/alphap-1)*(zetap^(1/rhop)*k_ss^Rhop + (1-zetap)^(1/rhop)*lbraggh_ss^Rhop)^(alphap/Rhop-1)*(delkh*(kh_ss)^(KapKP)+(1-delkh)*(km_ss)^(KapKP))^(Rhop/KapKP-1)*(km_ss)^(KapKP-1)     ;


mpkcheck = mpkk_ss - mpk_ss ;
mpzcheck = mpzz_ss - mpz_ss ;





%xh_ss = deltta*kh_ss ;
%xm_ss = deltta*km_ss ;
x_ss = deltta*k_ss ; 
xz_ss = deltta*Z_ss ; 
tqz_ss = 1;


wh_ss = (1/(1+tauf_ss))*(mplh_ss + (1-rhonh - 1/bettap)*kappavh/upsilonh_ss) ;
wm_ss = (1/(1+tauf_ss))*(mplm_ss + (1-rhonm - 1/bettap)*kappavm/upsilonm_ss) ;
wl_ss = (1/(1+tauf_ss))*(mpll_ss + (1-rhonl - 1/bettap)*kappavl/upsilonl_ss) ;
wmh_ss = (1/(1+tauf_ss))*(mplmh_ss + (1-rhonmh - 1/bettap)*kappavmh/upsilonmh_ss) ;



ubwh_ss = 0.250 ;
ubwm_ss = 0.350 ;
ubwl_ss = 0.350 ; %%%CHANGE AFTER IT WORKS
ubwmh_ss = 0.250 ;
ubh = ubwh_ss*wh_ss ;
ubm = ubwm_ss*wm_ss ;
ubmh = ubwmh_ss*wmh_ss ;
ubl = ubwl_ss*wl_ss ;

%geovery = 0.110 ;
covery = 0.67 ; %0.67
xovery = 0.12 ;

geovery = 1 - covery - xovery ; %x_ss/y_ss ;

ge_ss = geovery*y_ss ;


gcoverge = 0.3118 ;  %From 81000-0032
gxoverge = 	0.5408; %From 81000-0032
zoverge = 0.05; %From 81000-0032

xg_ss = 0 ;
gxoverge = xg_ss/ge_ss ;
rhoxg = 0;
rhogxv = 0;
zetabgx = 0;
zetaygx = 0;
sigmaexg = 0;

surp_ss = 0 ;
c_ss = y_ss*covery ;
ge_ss = y_ss - c_ss - x_ss - xg_ss - xz_ss - (kappavh)*vh_ss  - kappavl*vl_ss- kappavm*vm_ss - kappavmh*vmh_ss ;
gc_ss = (gcoverge + gxoverge)/(gcoverge + gxoverge + zoverge)*ge_ss ;
%c_ss = y_ss-(x_ss + (kappavh)*vh_ss + kappavm*vm_ss  + kappavl*vl_ss + ge_ss);
 %taxc_ss = tauc_ss*c_ss;
% taxw_ss = tauw_ss*(wh_ss*Nh_ss*hh_ss + wmh_ss*Nmh_ss*hmh_ss + wm_ss*Nm_ss*hm_ss + wl_ss*Nl_ss*hl_ss) ;
% taxf_ss = tauf_ss*(wh_ss*Nh_ss*hh_ss + wmh_ss*Nmh_ss*hmh_ss + wm_ss*Nm_ss*hm_ss + wl_ss*Nl_ss*hl_ss) ;
% 
% tax_ss = taxw_ss + taxf_ss + taxc_ss ;
% 
% z_ss = max(0,tax_ss - gc_ss - xg_ss - ubh*Uh_ss - ubmh*Umh_ss- ubm*Um_ss - ubl*Ul_ss) ;
% zh_ss = z_ss ;
% ge_ss = xg_ss + gc_ss + z_ss ;
% taxdelta =tax_ss - (ge_ss + ubh*Uh_ss + ubm*Um_ss + ubl*Ul_ss + ubmh*Umh_ss) ;
z_ss = ge_ss - gc_ss ;
taxw_ss = tauw_ss*(wh_ss*Nh_ss*hh_ss + wl_ss*Nl_ss*hl_ss+ wmh_ss*Nmh_ss*hmh_ss + wm_ss*Nm_ss*hm_ss) ; %
taxf_ss = tauf_ss*(wh_ss*Nh_ss*hh_ss + wmh_ss*Nmh_ss*hmh_ss + wm_ss*Nm_ss*hm_ss +wl_ss*Nl_ss*hl_ss) ;%
tax_ss = ge_ss + (ubh*Uh_ss  + ubl*Ul_ss+ ubmh*Umh_ss + ubm*Um_ss) ; %
tauc_ss = (tax_ss - taxw_ss - taxf_ss)/c_ss ;
taxc_ss = tauc_ss*c_ss ;


%z_ss = max(0,tax_ss - gc_ss - xg_ss - ubh*Uh_ss - ubmh*Umh_ss- ubm*Um_ss - ubl*Ul_ss) ;
taxdelta =tax_ss - (ge_ss + ubh*Uh_ss  + ubl*Ul_ss + ubm*Um_ss+ ubmh*Umh_ss) ; %

cgovery = gc_ss/y_ss ;
xgovery = xg_ss/y_ss ;
zovery = z_ss/y_ss ;

cm_ss = ((1-tauw_ss)*wm_ss*nm_ss*hm_ss + ubm*um_ss + z_ss)/(1+tauc_ss) ; %- taxl_ss - bl_ss*(1-r_ss)
cl_ss = ((1-tauw_ss)*wl_ss*nl_ss*hl_ss + ubl*ul_ss + z_ss)/(1+tauc_ss) ; %- taxl_ss - bl_ss*(1-r_ss)
cmh_ss = ((1-tauw_ss)*wmh_ss*nmh_ss*hmh_ss + ubmh*umh_ss +mpk_ss*km_ss + z_ss -xm_ss - bm_ss*(1+r_ss-1))/(1+tauc_ss) ; 

ch_ss = (c_ss  - varphil_ss*cl_ss- varphim_ss*cm_ss - varphimh_ss*cmh_ss)/varphih_ss ; %

muh_ss = (((1-kappac)*ch_ss)^(-sigmap))/(1+tauc_ss) ;
mum_ss = (((1-kappac)*cm_ss)^(-sigmalp))/(1+tauc_ss) ;
mul_ss = (((1-kappac)*cl_ss)^(-sigmalp))/(1+tauc_ss) ;
mumh_ss = (((1-kappac)*cmh_ss)^(-sigmap))/(1+tauc_ss) ;


phi0mhp = mumh_ss*wmh_ss*nmh_ss*(1-tauw_ss)/((hmh_ss*(1-kappah))^(etap)) ;
phi0mp = mum_ss*wm_ss*nm_ss*(1-tauw_ss)/((hm_ss*(1-kappah))^(etalp)) ;
phi0hp = muh_ss*wh_ss*nh_ss*(1-tauw_ss)/((hh_ss*(1-kappah))^(etap)) ;
phi0lp = mul_ss*wl_ss*nl_ss*(1-tauw_ss)/((hl_ss*(1-kappah))^(etalp)) ;


Lambdah_ss = (-phi0hp/(1+etap)*hh_ss^(1+etap) + bettap*(muh_ss*(wh_ss*hh_ss*(1-tauw_ss)-ubh)))/(1-bettap*((1-rhonh)-oomegah_ss)) ; %(muh_ss*((1-tauw_ss)*wh_ss*hh_ss - ubh) -phi0hp/(1+etap)*hh_ss^(1+etap))/( 1/bettap - (1-rhonh - oomegah_ss)) ;
Lambdam_ss =  (-phi0mp/(1+etap)*hm_ss^(1+etap) + bettap*(mum_ss*(wm_ss*hm_ss*(1-tauw_ss)-ubm)))/(1-bettap*((1-rhonm)-oomegam_ss)) ;%(mum_ss*((1-tauw_ss)*wm_ss*hm_ss - ubm))/( 1/bettap - (1-rhonm - oomegam_ss)) ;
Lambdal_ss =  (-phi0lp/(1+etap)*hl_ss^(1+etap) + bettap*(mul_ss*(wl_ss*hl_ss*(1-tauw_ss)-ubl)))/(1-bettap*((1-rhonl)-oomegal_ss)) ;%(mul_ss*((1-tauw_ss)*wl_ss*hl_ss - ubl))/( 1/bettap - (1-rhonl - oomegal_ss)) ;
Lambdamh_ss =  (-phi0mhp/(1+etap)*hmh_ss^(1+etap) + bettap*(mumh_ss*(wmh_ss*hmh_ss*(1-tauw_ss)-ubmh)))/(1-bettap*((1-rhonmh)-oomegamh_ss)) ;%(mumh_ss*((1-tauw_ss)*wmh_ss*hmh_ss - ubmh))/( 1/bettap - (1-rhonmh - oomegamh_ss)) ;



Phih = (Lambdah_ss*oomegah_ss + ubh*muh_ss)/((lh_ss^(-zeta))) ;
Phimh = (Lambdamh_ss*oomegamh_ss + ubmh*mumh_ss)/((lmh_ss^(-zeta))) ;
Phim = (Lambdam_ss*oomegam_ss + ubm*mum_ss)/((lm_ss^(-zeta))) ;
Phil = (Lambdal_ss*oomegal_ss + ubl*mul_ss)/((ll_ss^(-zeta))) ;

varthetah = (wh_ss - (1/(1+tauf_ss))*(mplh_ss + (1-rhonh)*kappavh/upsilonh_ss)) * ( (Phih*(lh_ss)^(-zeta))/(muh_ss*(1-tauw_ss)*hh_ss) - (1-rhonh)*Lambdah_ss/(muh_ss*(1-tauw_ss)*hh_ss) - (1/(1+tauf_ss))*(mplh_ss + (1-rhonh)*kappavh/upsilonh_ss))^(-1) ;
varthetam = (wm_ss - (1/(1+tauf_ss))*(mplm_ss + (1-rhonm)*kappavm/upsilonm_ss)) * ( (Phim*(lm_ss)^(-zeta))/(mum_ss*(1-tauw_ss)*hm_ss) - (1-rhonm)*Lambdam_ss/(mum_ss*(1-tauw_ss)*hm_ss) - (1/(1+tauf_ss))*(mplm_ss + (1-rhonm)*kappavm/upsilonm_ss))^(-1) ;
varthetal = (wl_ss - (1/(1+tauf_ss))*(mpll_ss + (1-rhonl)*kappavl/upsilonl_ss)) * ( (Phil*(ll_ss)^(-zeta))/(mul_ss*(1-tauw_ss)*hl_ss) - (1-rhonl)*Lambdal_ss/(mul_ss*(1-tauw_ss)*hl_ss) - (1/(1+tauf_ss))*(mpll_ss + (1-rhonl)*kappavl/upsilonl_ss))^(-1) ;
varthetamh = (wmh_ss - (1/(1+tauf_ss))*(mplmh_ss + (1-rhonmh)*kappavmh/upsilonmh_ss)) * ( (Phimh*(lmh_ss)^(-zeta))/(mumh_ss*(1-tauw_ss)*hmh_ss) - (1-rhonmh)*Lambdamh_ss/(mumh_ss*(1-tauw_ss)*hmh_ss) - (1/(1+tauf_ss))*(mplmh_ss + (1-rhonmh)*kappavmh/upsilonmh_ss))^(-1) ;

phihn = 1 ;
phihm = 1 ;

taxwh_ss = tauw_ss*hh_ss*wh_ss*nh_ss ;
taxwm_ss = tauw_ss*hm_ss*wm_ss*nm_ss ;
taxwl_ss = tauw_ss*hl_ss*wl_ss*nl_ss ;
taxwmh_ss = tauw_ss*hmh_ss*wmh_ss*nmh_ss ;


ex_ss = 0.3*y_ss ;
rer_ss = 1 ;
ph_ss = 1 ;
tb_ss = 0 ;
b_ss = 0 ;
rstar_ss = 1/bettap -1 ;
bg_ss = 0 ;
yf_ss = 1 ; 
thetap       = 2;
thetastarp   = thetap;
vp        = (y_ss-ex_ss)/(c_ss + x_ss + xz_ss + (kappavh)*vh_ss  + kappavl*vl_ss + kappavmh*vmh_ss+ kappavm*vm_ss  + gc_ss + z_ss) ; %
vstarp    = (ex_ss)/(yf_ss);
m_ss =1 ;
psi_ss = 1 ;
psih_ss = 1;
psix_ss = 1;
psixz_ss = 1;
psiz_ss = 1;
psigc_ss = 1 ;
g_ss   = 1;
grmh_ss = 1;
gdp_ss = y_ss ;
tq_ss = 1;

iotax_ss           = kappaxp*xh_ss;
iotax_diffcont_ss  = kappaxp;
iotax_difflag_ss   = 0;

iotax_t = iotax_ss ;
iotax_diffcont_t = iotax_diffcont_ss;
iotax_difflag_t = iotax_difflag_ss ;

iotaxm_ss           = kappaxp*xm_ss;
iotaxm_diffcont_ss  = kappaxp;
iotaxm_difflag_ss   = 0;

iotaxm_t = iotaxm_ss ;
iotaxm_diffcont_t = iotaxm_diffcont_ss;
iotaxm_difflag_t = iotaxm_difflag_ss ;

iotaxz_ss           = kappaxp*xz_ss;
iotaxz_diffcont_ss  = kappaxp;
iotaxz_difflag_ss   = 0;

iotaxz_t = iotaxz_ss ;
iotaxz_diffcont_t = iotaxz_diffcont_ss;
iotaxz_difflag_t = iotaxz_difflag_ss ;
tqz_t = log(tq_ss) ;


lbrinch_ss= (wh_ss)*(hh_ss)*(nh_ss) ;
lbrincl_ss= (wl_ss)*(hl_ss)*(nl_ss) ;
lbrincm_ss = (wm_ss)*(hm_ss)*(nm_ss) ;
lbrincmh_ss = (wmh_ss)*(hmh_ss)*(nmh_ss) ;


rhoa	=	0.6972	;
rhogc	=	0.6904	;
rhogcv	=	0.6984	;
rhoyf	=	0.6934	;
rhom	=	0.7050	;
rhopsi	=	0.6988	;
rhopsix	=	0.7021	;
rhoz	=	0.7074	;
rhozm	=	0.6965	;
rhopsixz	=	0.6961	;
zetayz	=	0.0494	;
zetabz	=	0.0486	;
zetaygc	=	0.0499	;
zetabgc	=	0.0489	;
thetap	=	2.0592	;
phixp	=	1.9986	;
phixzp	=	1.9833	;
bhc	=	0.0101	;
			
			
			
			
sigmaea	=	0.2392	;
sigmaex	=	0.2911	;
sigmaepsi	=	0.2334	;
sigmaez	=	0.3741	;
sigmaeyf	=	0.2329	;
sigmaem	=	0.4771	;
sigmaegc	=	0.2325	;
sigmaexz	=	0.5220	;
		
sigmaepsih = 0.5452 ;			
			
sigmaemh	=	sigmaem	;
sigmaebp = sigmaea ;			
sigmaez_ME	=	sigmaez	;

NHNT_ss = Nh_ss/(Nmh_ss+Nh_ss+Nl_ss+Nm_ss) ;
NLNT_ss = Nl_ss/(Nmh_ss+Nh_ss+Nl_ss+Nm_ss) ;
NMNT_ss  = Nm_ss/(Nmh_ss+Nh_ss+Nl_ss+Nm_ss) ;
NMHNT_ss = Nmh_ss/(Nmh_ss+Nh_ss+Nl_ss+Nm_ss) ;


NHNT_t = log(NHNT_ss) ;
NLNT_t= log(NLNT_ss) ;
NMNT_t= log(NMNT_ss) ;
NMHNT_t= log(NMHNT_ss) ;


y_t	=	log	(	y_ss	)	;
k_t	=	log	(	k_ss	)	;
lbraggl_t	=	log	(	lbraggl_ss	)	;
lbraggh_t	=	log	(	lbraggh_ss	)	;
x_t	=	log	(	x_ss	)	;
rhok_t	=	log	(	mpk_ss	)	;
hh_t	=	log	(	hh_ss	)	;
ch_t	=	log	(	ch_ss	)	;
wh_t	=	log	(	wh_ss	)	;
wm_t	=	log	(	wm_ss	)	;
cm_t	=	log	(	cm_ss	)	;
hm_t	=	log	(	hm_ss	)	;
b_t	=		(	b_ss	)	;
r_t	=		(	r_ss	)	;
rer_t	=	log	(	rer_ss	)	;
ph_t	=	log	(	ph_ss	)	;
c_t	=	log	(	c_ss	)	;
z_t	=	log	(	z_ss	)	;
bg_t	=	  	(	bg_ss	)	;
taxwh_t	=	log	(	taxwh_ss	)	;
taxwm_t	=	log	(	taxwm_ss	)	;
taxw_t	=	log	(	taxw_ss	)	;
taxc_t	=	log	(	taxc_ss	)	;
taxf_t	=	log	(	taxf_ss	)	;
gc_t	=	log	(	gc_ss	)	;
tax_t	=	log	(	tax_ss	)	;
ge_t	=	log	(	ge_ss	)	;
surp_t	=		(	surp_ss	)	;
a_t	=	log	(	a_ss	)	;
m_t	=	log	(	m_ss	)	;
yf_t	=	log	(	yf_ss	)	;
psi_t	=	log	(	psi_ss	)	;
psix_t	=	log	(	psix_ss	)	;
psih_t	=	log	(	psih_ss	)	;
psiz_t	=	log	(	psiz_ss	)	;
psigc_t	=	log	(	psigc_ss	)	;
dy	=		(	0	)	;
dx	=		(	0	)	;
dc	=		(	0	)	;
dz	=		(	0	)	;
dnm	=		(	0	)	;
dyf	=		(	0	)	;
dgc	=		(	0	)	;
dth	=		(	0	)	;
g_t	=	log	(	g_ss	)	;
varphih_t	=	log	(	varphih_ss	)	;
varphim_t	=	log	(	varphim_ss	)	;
partich_t	=	log	(	partich_ss	)	;
unemph_t	=	log	(	unemph_ss	)	;
Uh_t	=	log	(	Uh_ss	)	;
Nh_t	=	log	(	Nh_ss	)	;
uh_t	=	log	(	uh_ss	)	;
nh_t	=	log	(	nh_ss	)	;
mh_t	=	log	(	mh_ss	)	;
vh_t	=	log	(	vh_ss	)	;
oomegah_t	=	log	(	oomegah_ss	)	;
upsilonh_t	=	log	(	upsilonh_ss	)	;
thetah_t	=	log	(	thetah_ss	)	;
lh_t	=	log	(	lh_ss	)	;
Lambdah_t	=	log	(	Lambdah_ss	)	;
mplh_t	=	log	(	mplh_ss	)	;
muh_t	=	log	(	muh_ss	)	;
lbrh_t	=	log	(	lbrh_ss	)	;
particm_t	=	log	(	particm_ss	)	;
unempm_t	=	log	(	unempm_ss	)	;
Um_t	=	log	(	Um_ss	)	;
Nm_t	=	log	(	Nm_ss	)	;
um_t	=	log	(	um_ss	)	;
nm_t	=	log	(	nm_ss	)	;
mm_t	=	log	(	mm_ss	)	;
vm_t	=	log	(	vm_ss	)	;
oomegam_t	=	log	(	oomegam_ss	)	;
upsilonm_t	=	log	(	upsilonm_ss	)	;
thetam_t	=	log	(	thetam_ss	)	;
lm_t	=	log	(	lm_ss	)	;
Lambdam_t	=	log	(	Lambdam_ss	)	;
mplm_t	=	log	(	mplm_ss	)	;
mum_t	=	log	(	mum_ss	)	;
lbrm_t	=	log	(	lbrm_ss	)	;
particl_t	=	log	(	particl_ss	)	;
unempl_t	=	log	(	unempl_ss	)	;
Ul_t	=	log	(	Ul_ss	)	;
Nl_t	=	log	(	Nl_ss	)	;
ul_t	=	log	(	ul_ss	)	;
nl_t	=	log	(	nl_ss	)	;
ml_t	=	log	(	ml_ss	)	;
vl_t	=	log	(	vl_ss	)	;
oomegal_t	=	log	(	oomegal_ss	)	;
upsilonl_t	=	log	(	upsilonl_ss	)	;
thetal_t	=	log	(	thetal_ss	)	;
ll_t	=	log	(	ll_ss	)	;
Lambdal_t	=	log	(	Lambdal_ss	)	;
mpll_t	=	log	(	mpll_ss	)	;
mul_t	=	log	(	mul_ss	)	;
wl_t	=	log	(	wl_ss	)	;
cl_t	=	log	(	cl_ss	)	;
hl_t	=	log	(	hl_ss	)	;
taxwl_t	=	log	(	taxwl_ss	)	;
varphil_t	=	log	(	varphil_ss	)	;
lbrl_t	=	log	(	lbrl_ss	)	;
particmh_t	=	log	(	particmh_ss	)	;
unempmh_t	=	log	(	unempmh_ss	)	;
Umh_t	=	log	(	Umh_ss	)	;
Nmh_t	=	log	(	Nmh_ss	)	;
umh_t	=	log	(	umh_ss	)	;
nmh_t	=	log	(	nmh_ss	)	;
mmh_t	=	log	(	mmh_ss	)	;
vmh_t	=	log	(	vmh_ss	)	;
oomegamh_t	=	log	(	oomegamh_ss	)	;
upsilonmh_t	=	log	(	upsilonmh_ss	)	;
thetamh_t	=	log	(	thetamh_ss	)	;
lmh_t	=	log	(	lmh_ss	)	;
Lambdamh_t	=	log	(	Lambdamh_ss	)	;
mplmh_t	=	log	(	mplmh_ss	)	;
mumh_t	=	log	(	mumh_ss	)	;
wmh_t	=	log	(	wmh_ss	)	;
cmh_t	=	log	(	cmh_ss	)	;
hmh_t	=	log	(	hmh_ss	)	;
grmh_t	=	log	(	grmh_ss	)	;
taxwmh_t	=	log	(	taxwmh_ss	)	;
varphimh_t	=	log	(	varphimh_ss	)	;
lbrmh_t	=	log	(	lbrmh_ss	)	;
xm_t	=	log	(	xm_ss	)	;
km_t	=	log	(	km_ss	)	;
kh_t	=	log	(	kh_ss	)	;
xh_t	=	log	(	xh_ss	)	;
X_t	=	log	(	X_ss	)	;
mpz_t	=	log	(	mpzz_ss	)	;
Z_t	=	log	(	Z_ss	)	;
xz_t	=	log	(	xz_ss	)	;
V_t	=	log	(	V_ss	)	;
mpkh_t	=	log	(	mpkh_ss	)	;
mpkm_t	=	log	(	mpkm_ss	)	;
bm_t	=		(	bm_ss	)	;
bh_t	=		(	bh_ss	)	;
gdp_t	=	log	(	gdp_ss	)	;
tb_t	=		(	tb_ss	)	;

tq_t = log(tq_ss) ;
tqm_t = log(tq_ss) ;
psixz_t = log(psixz_ss) ;
bp_t = log(bp) ;
betta = bettap ;

whwl_t = log(wh_ss/wl_ss) ;
whwmh_t = log(wh_ss/wmh_ss) ;
wlwm_t = log(wl_ss/wm_ss) ;
wmhwml_t = log(wmh_ss/wm_ss) ;

lbrinch_t = log(lbrinch_ss) ;
lbrincl_t = log(lbrincl_ss) ;
lbrincm_t = log(lbrincm_ss) ;
lbrincmh_t = log(lbrincmh_ss) ;

for iter = 1:length(M_.params) %update parameters set in the file
  eval([ 'M_.params(' num2str(iter) ') = ' M_.param_names(iter,:) ';' ])
end

NumberOfEndogenousVariables = M_.orig_endo_nbr; %auxiliary variables are set automatically
for ii = 1:NumberOfEndogenousVariables
  varname = deblank(M_.endo_names(ii,:));
  eval(['ys(' int2str(ii) ') = ' varname ';']);
end
